<?php

# Hummingbird, v0.61, released 2009-12-13
# Copyright (c) 2009 by Kagan D. MacTane.
# Released under a Creative Commons license. See:
# http://kai.mactane.org/software/hummingbird/
# and
# http://creativecommons.org/licenses/by-sa/3.0/us/

$cache_file = preg_replace("/(-cache)?\.php$/", '.xml', __FILE__);

if (`ps ax | grep hummingbird-cache | grep -v grep | wc -l` > 1) {
	exit;
}

if (! isset($argc)) exit;
if ($argc != 4) exit;
if (! is_numeric($argv[1]) && is_numeric($argv[3])) exit;

$count = $argv[1];
$twitter_username = $argv[2];
$cache_time = $argv[3];

if (file_exists($cache_file)) {
	$cachefile_timestamp = filemtime($cache_file);
	$now = time();
	$cachefile_age = $now - $cachefile_timestamp;
	if ($cachefile_age < 60) exit;
	if ($cachefile_age < ($cache_time / 2)) {
		exit;
	}
	if (filesize($cache_file)) {
        $xml = new SimpleXMLElement(file_get_contents($cache_file));
        if ($xml->ratelimit->remaining / $xml->ratelimit->limit < 0.05) {
        	if ($now < $xml->ratelimit->reset) {
        		exit;
        	}
        }
    }
}

$data_url = "http://twitter.com/statuses/user_timeline/$twitter_username.xml?count=$count";
$http = http_get($data_url);
if (substr($http['status'], 0, 1) != 2) {
	throw new RuntimeException("HTTP call returned " . $http['status'] . " from URL $data_url");
}
$xml = new SimpleXMLElement($http['body']);
$rl = $xml->addChild('ratelimit');
$rl->addChild('limit', $http['headers']['X-RateLimit-Limit']);
$rl->addChild('remaining', $http['headers']['X-RateLimit-Remaining']);
$rl->addChild('reset', $http['headers']['X-RateLimit-Reset']);
$xml_source = $xml->asXML();

$fh = safeopen($cache_file, $err, 'w');
if ($fh) {
	fwrite($fh, $xml_source);
	if (! @fclose($fh)) {
		throw new RuntimeException("Couldn't write new cache file: $php_errormsg");
	}
} else {
	throw new RuntimeException("Couldn't open new cache file for writing: $err");
}

return $xml;

function handle_alarm() {
	exit;
}

function http_get($url, $prev = array()) {
	global $cache_time;
	if (preg_match("/^http:\/\/([-\w\.]+)(\/[\S]+)?/", $url, $match)) {
		$hostname = $match[1];
		$remote_path = count($match) > 2 ? $match[2] : '/';
	} else {
		return array('error' => "Invalid URL!");
	}
	try {
		$fp = fsockopen($hostname, 80, $errno, $errstr);
		if (! $fp) {
			return array('error' => $errstr);
		}
	} catch (RuntimeException $e) {
		return array('error' => "Unable to open socket: " . $e->getMessage);
	}
	fwrite($fp, "GET $remote_path HTTP/1.1\r\n");
	fwrite($fp, "Host: $hostname\r\n");
	fwrite($fp, "Accept: application/xml, text/*\r\n");
	fwrite($fp, "Accept-Charset: us-ascii, iso-8859-1, unicode-1-1\r\n");
	fwrite($fp, "User-Agent: script running PHP v" . phpversion() . "\r\n");
	fwrite($fp, "Connection: close\r\n");
	fwrite($fp, "\r\n");
	
	$alarm_delay = floor($cache_time * 0.9);
	declare(ticks = 1);
	pcntl_signal(SIGALRM, "handle_alarm");
	pcntl_alarm($alarm_delay);
	
	$raw_response = '';
	while (!feof($fp)) {
		$raw_response .= fgets($fp);
	}
	fclose($fp);
	
	list($raw_headers, $raw_body) = preg_split("/\r?\n\r?\n/", $raw_response, 2);
	foreach (preg_split("/\r?\n/", $raw_headers) as $hdr) {
		if (preg_match("/^HTTP\/\d\.\d (\d{3}) (.+)/", $hdr, $match)) {
			$status_code = $match[1];
			$status_text = trim($match[2]);
		} elseif (preg_match("/^([-\w]+):\s+(.+)/", $hdr, $match)) {
			$headers[$match[1]] = trim($match[2]);
		}
	}
	if (substr($status_code, 0, 1) == '3' && array_key_exists('Location', $headers)) {
		if (in_array($headers['Location'], $prev)) {
			throw new RuntimeException("HTTP redirects have looped back to " . $headers['Location']);
		}
		array_push($prev, $url);
		return http_get($headers['Location'], $prev);
	}
	$trimmed_body = preg_replace("/^[0-9a-fA-F]{4}\r?\n/", '', $raw_body);
	return array(
		'status' => "$status_code $status_text",
		'status_code' => $status_code,
		'status_text' => $status_text,
		'headers' => $headers,
		'body' => $trimmed_body,
		'raw_body' => $raw_body,
		'raw_response' => $raw_response,
		'error' => null,
	);
}

function safeopen ($filename, &$errmsg, $mode  = 'r', $lock = LOCK_EX) {
	$retry_msecs = 250;
	$timeout_secs = 5;
	
	global $php_errormsg;
	
	$elapsed = 0;
	$fh = null;
	while (! $fh) {
		# This will always fail the first time around.
		if ($elapsed >= $timeout_secs * 1000) {
			if (strlen($errmsg)) {
				$errmsg = "Couldn't open file: ".$errmsg;
			} else {
				$errmsg = "Couldn't open file; no other error data available.";
			}
			return false;
		}
		$fh = @fopen($filename, $mode);
		if (! $fh) {
			$errmsg = $php_errormsg;
			usleep($retry_msecs * 1000);
			$elapsed += $retry_msecs;
		}
	}
	
	while (! @flock($fh, $lock+LOCK_NB)) {
		$errmsg = $php_errormsg;
		if ($elapsed >= $timeout_secs * 1000) {
			if (strlen($errmsg)) {
				$errmsg = "Couldn't acquire lock on file: ".$errmsg;
			} else {
				$errmsg = "Couldn't acquire lock on file.";
			}
			fclose($fh);
			return false;
		}
		usleep($retry_msecs * 1000);
		$elapsed += $retry_msecs;
	}
	return $fh;
}

?>
